/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CPalette.h,v 1.2 1999/09/17 04:20:47 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CPalette_h	// [
#define Included_CPalette_h

#include "pgpClassesConfig.h"

_PGP_BEGIN

// Class CPalette

class CPalette
{
	NOT_COPYABLE(CPalette)

public:
	CPalette();
	CPalette(HPALETTE palette);
	CPalette(const LOGPALETTE& lp);
	CPalette(HDC dc);
	CPalette(const BITMAPINFO *pBMI, PGPUInt32& numColors);
	~CPalette();

	CPalette&	operator=(HPALETTE palette);

	operator HPALETTE() const {return mPalette;}
	HPALETTE	Get() const {return mPalette;}

	PGPBoolean	IsAttached() const;
	PGPBoolean	WeCreated() const {return mWeCreated;}

	void	Create(const LOGPALETTE& lp);
	void	CreateHalftone(HDC dc);
	void	CreateDIB(const BITMAPINFO *pBMI, PGPUInt32& numColors);
	void	Attach(HPALETTE palette);
	void	Clear();

private:
	PGPBoolean	mWeCreated;
	HPALETTE	mPalette;
};


// Class CPalette member functions

inline 
CPalette::CPalette() : mWeCreated(FALSE), mPalette(NULL)
{
}

inline 
CPalette::CPalette(HPALETTE palette) : mWeCreated(FALSE), mPalette(NULL)
{
	Attach(palette);
}

inline 
CPalette::CPalette(const LOGPALETTE& lp) : mWeCreated(FALSE), mPalette(NULL)
{
	Create(lp);
}

inline 
CPalette::CPalette(HDC dc) : mWeCreated(FALSE), mPalette(NULL)
{
	CreateHalftone(dc);
}

inline 
CPalette::CPalette(const BITMAPINFO *pBMI, PGPUInt32& numColors) : 
	mWeCreated(FALSE), mPalette(NULL)
{
	CreateDIB(pBMI, numColors);
}

inline 
CPalette::~CPalette()
{
	try
	{
		Clear();
	}
	catch (CComboError&) { }
}

inline 
PGPBoolean 
CPalette::IsAttached() const
{
	return IsntNull(mPalette);
}

_PGP_END

#endif	// ] Included_CPalette_h
